#include<bits/stdc++.h>

using namespace std;

const long long int inf = 2e18 + 5;
const int max_n = 5e5 + 5;

vector<int> nodes;
stack<int> to_erase;
stack<int> to_erase_xy;
bool seen[max_n] = {0};
int marks[max_n] = {0};
int ans_node;

// t is for the type of mark we do (0 - erase, 1 - x, 2 - y, 3 - both)
void mark(int node, int t, vector<vector<int>> &prv){
    seen[node] = true;
    marks[node] |= t;
    to_erase.push(node);
    to_erase_xy.push(node);
    for (int elm : prv[node]){
        if (!seen[elm])
            mark(elm, t, prv);
    }
}


void ans_find(int node, vector<vector<int>> &prv){
    seen[node] = true;
    to_erase.push(node);
    for (int elm : prv[node]){
        if (marks[elm] == 3){
            if (ans_node == -1){
                ans_node = elm;
            }
            else if (nodes[ans_node] > nodes[elm]){
                ans_node = elm;
            }
        }
        else if (marks[elm] != 0 && !seen[elm]){
            ans_find(elm, prv);
        }
    }
    return;
}


void Putevi(int N, int M, int Q, int* U, int* V, int* W, int* X, int* Y, int* Ans){
    vector<vector<pair<int, int>>> adjs(N + 1);
    for (int i = 1; i <= N; i++){
        adjs[U[i]].push_back(make_pair(W[i], V[i]));
        adjs[V[i]].push_back(make_pair(W[i], U[i]));
    }
    vector<long long int> d(N + 1, inf);
    vector<bool> visited(N + 1, false);
    nodes.assign(N + 1, 0);
    vector<vector<int>> prv(N + 1);
    d[1] = 0;
    nodes[1] = 0;
    int v_count = 0;
    int best_node;
    long long int best_dist;
    while (v_count != N){
        best_dist = inf;
        best_node = -1;
        for (int i = 1; i <= N; i++){
            if (d[i] < best_dist && !visited[i]){
                best_node = i;
                best_dist = d[i];
            }
        }
        v_count++;
        visited[best_node] = true;
        for (pair<int, int> p : adjs[best_node]){
            // treba da se distance update-uje
            if (d[best_node] + p.first < d[p.second]){
                while (!prv[p.second].empty()) prv[p.second].pop_back();
                d[p.second] = d[best_node] + p.first;
                prv[p.second].push_back(best_node);
                nodes[p.second] = nodes[best_node] + 1;
            }
            else if (d[best_node] + p.first == d[p.second]){
                prv[p.second].push_back(best_node);
                nodes[p.second] = min(nodes[best_node] + 1, nodes[p.second]);
            }
        }
    }
    /*
    for (int i = 1; i <= N; i++){
        cout << "node " << i << ":" << endl;
        cout << "d: " << d[i] << endl;
        cout << "nodes before: " << nodes[i] << endl;
        cout << "prv:" << endl;
        for (int elm : prv[i]) cout << elm << " ";
        cout << endl;
    }
    */
    for (int tc = 1; tc <= Q; tc++){
        mark(X[tc], 1, prv);
        while (!to_erase.empty()){
            seen[to_erase.top()] = false;
            to_erase.pop();
        }
        mark(Y[tc], 2, prv);
        while (!to_erase.empty()){
            seen[to_erase.top()] = false;
            to_erase.pop();
        }
        // ovde neke stvari da se rade
        ans_node = -1;
        if (X[tc] == Y[tc]){
            ans_node = X[tc];
        }
        else{
            if (marks[X[tc]] != 3) ans_find(X[tc], prv);
            if (marks[Y[tc]] != 3) ans_find(Y[tc], prv);
        }
        Ans[tc] = nodes[ans_node] + 1;
        while (!to_erase.empty()){
            seen[to_erase.top()] = false;
            to_erase.pop();
        }
        while (!to_erase_xy.empty()){
            marks[to_erase_xy.top()] = 0;
            to_erase_xy.pop();
        }
    }
}
/*
5 5 1
1 2 2
1 3 1
3 5 2
3 4 3
2 4 2
5 4

4 5 3
1 2 2
2 3 3
2 4 5
1 3 5
4 3 4
2 4
3 4
2 2
*/